package com.vf106.tools.utils;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.vf106.tools.listener.OnHttpFailListener;
import com.vf106.tools.listener.OnHttpSuccessListener;
import com.vf106.tools.utils.volley.MyJsonObjectRequest;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by maorui on 2017/12/2.
 */

public class HttpUtil {
    private static final String TAG = "HttpUtil";

    public static void getData(RequestQueue requestQueue, int requestMethod, String url, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener, Map<String, String> headers) {
        if (headers == null) {
            headers = new HashMap<>();
        }

        final Map<String, String> finalHeaders = headers;
        MyJsonObjectRequest jsonRequest = new MyJsonObjectRequest(requestMethod, url, null, listener, errorListener) {
            @Override
            public Map<String, String> getHeaders() {
                return finalHeaders;
            }
        };
        requestQueue.add(jsonRequest);
    }

    public static void postData(RequestQueue requestQueue, int requestMethod, String url, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener, Object params, Map<String, String> headers) {
        if (headers == null) {
            headers = new HashMap<>();
        }
        final Map<String, String> finalHeaders = headers;
        MyJsonObjectRequest jsonRequest = new MyJsonObjectRequest(requestMethod, url, JSON.toJSONString(params), listener, errorListener) {
            @Override
            public Map<String, String> getHeaders() {
                finalHeaders.put("Accept", "application/json");
                finalHeaders.put("Content-Type", "application/json; charset=UTF-8");
                return finalHeaders;
            }
        };
        jsonRequest.setRetryPolicy(new DefaultRetryPolicy(20 * 1000, DefaultRetryPolicy.DEFAULT_MAX_RETRIES, DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));
        requestQueue.add(jsonRequest);
    }

    public static void postFormData(RequestQueue requestQueue, int requestMethod, String url, Response.Listener<String> listener, Response.ErrorListener errorListener, final Map<String, String> params, Map<String, String> headers) {
        if (headers == null) {
            headers = new HashMap<>();
        }

        final Map<String, String> finalHeaders = headers;
        StringRequest jsonRequest = new StringRequest(requestMethod, url, listener, errorListener) {
            @Override
            public String getBodyContentType() {
                return "application/x-www-form-urlencoded";
            }

            @Override
            public Map<String, String> getHeaders() {
                finalHeaders.put("Accept", "application/json");
                return finalHeaders;
            }

            @Override
            protected Map<String, String> getParams() {
                return params;
            }
        };
        requestQueue.add(jsonRequest);
    }

    public static void processResponse(Context context, JSONObject responseObj, String url, String successMsg, String failMessage, OnHttpSuccessListener listener) {
        processResponse(context, responseObj, url, successMsg, failMessage, listener, null);
    }

    public static void processResponse(Context context, JSONObject responseObj, String url, String successMsg, String failMessage, OnHttpSuccessListener listener, OnHttpFailListener failListener) {
        Log.d(TAG, "response -> url = " + url + ", response = " + responseObj);
        try {
            int code = responseObj.getInteger("code");
            if (code != 1 && code != 200) {
                if (!TextUtils.isEmpty(failMessage)) {
                    Utils.toast(context.getApplicationContext(), failMessage);
                    return;
                }

                String msg = responseObj.getString("msg");
                if (TextUtils.isEmpty(msg)) {
                    msg = responseObj.getString("message");
                }
                if (TextUtils.isEmpty(msg)) {
                    msg = "Server exception, please try again later!";
                }

                if (failListener != null) {
                    failListener.fail();
                }

                Utils.toast(context.getApplicationContext(), msg);
            } else {
                if (!TextUtils.isEmpty(successMsg)) {
                    Utils.toast(context.getApplicationContext(), successMsg);
                }
                if (listener != null) {
                    listener.success(responseObj);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void processError(Context context, VolleyError error, String url, String errorMsg) {
        Log.d(TAG, "error -> url = " + url + ", errorMsg = " + errorMsg);
        if (error.networkResponse != null) {
            byte[] errorData = error.networkResponse.data;
            int statusCode = error.networkResponse.statusCode;
            if (errorData != null) {
                String responseError = new String(errorData);
                Log.d(TAG, "error -> url = " + url + ", errorCode = " + statusCode + ", error = " + responseError);
                try {
                    JSONObject errorObj = JSONObject.parseObject(responseError);
                    errorMsg = errorMsg + " " + errorObj.getString("description");
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            if (statusCode == 401) { //
//                Intent i = new Intent(getActivity(), LoginActivity.class);
//                startActivity(i);
            }
        }
        if (!TextUtils.isEmpty(errorMsg)) {
            Utils.toast(context.getApplicationContext(), errorMsg);
        }
    }
}
